#!/bin/bash

MODEL_PATH="/data2/huggingface/Qwen/Qwen2.5-VL-7B-Instruct"
DATASET="scenefun3d"
TRAIN_DATA="./Projects/TimeZero/scenefun3d/benchmark_file_lists/train_scenes.txt"
EVAL_DATA="./Projects/TimeZero/scenefun3d/benchmark_file_lists/val_scenes.txt"
VIDEO_FOLDER="/data2/datasets/scenefun3d_video"
MAX_PIX=3584
MIN_PIX=16
NUM_WORKERS=1
OUTPUT_DIR="/data2/datasets/scenefun3d_preprocessed_data_maxpix_3584"

CUDA_VISIBLE_DEVICES=0 python preprocess_scannet.py \
  --model_name $MODEL_PATH \
  --dataset $DATASET \
  --train_data_path $TRAIN_DATA \
  --eval_data_path $EVAL_DATA \
  --video_folder $VIDEO_FOLDER \
  --max_pix_size $MAX_PIX \
  --min_pix_size $MIN_PIX \
  --num_workers $NUM_WORKERS \
  --output_dir $OUTPUT_DIR
